using System;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///User control to display details of an invoice
		///</summary>

		#endregion


	public class InvoiceDisplayPanel : GUI.controls.BaseControl
	{
		#region Variables

		private BOL.OutgoingShipmentCollection _Invoice;
		private BOL.IncomingShipment _Shipment;
		private bool _IncomingShipment;

		#endregion


		#region Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpShipment;
		private System.Windows.Forms.TextBox txtProcessingDT;
		private System.Windows.Forms.Label lblProcessingDT;
		private System.Windows.Forms.TextBox txtInvoice;
		private System.Windows.Forms.Label lblFacility;
		private System.Windows.Forms.Label lblInvoice;
		private System.Windows.Forms.TextBox txtFacility;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// InvoiceDisplayPanel class constructor
		/// </summary>
		public InvoiceDisplayPanel()
		{
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region Component Designer generated code

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(InvoiceDisplayPanel));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpShipment = new System.Windows.Forms.GroupBox();
			this.txtProcessingDT = new System.Windows.Forms.TextBox();
			this.lblProcessingDT = new System.Windows.Forms.Label();
			this.txtFacility = new System.Windows.Forms.TextBox();
			this.txtInvoice = new System.Windows.Forms.TextBox();
			this.lblFacility = new System.Windows.Forms.Label();
			this.lblInvoice = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpShipment.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpImage
			// 
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 40);
			this.grpImage.TabIndex = 1;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(28, 28);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 33;
			this.pictureBox1.TabStop = false;
			// 
			// grpShipment
			// 
			this.grpShipment.AccessibleDescription = "Shipment Details";
			this.grpShipment.AccessibleName = "Shipment Details";
			this.grpShipment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpShipment.Controls.Add(this.txtProcessingDT);
			this.grpShipment.Controls.Add(this.lblProcessingDT);
			this.grpShipment.Controls.Add(this.txtFacility);
			this.grpShipment.Controls.Add(this.txtInvoice);
			this.grpShipment.Controls.Add(this.lblFacility);
			this.grpShipment.Controls.Add(this.lblInvoice);
			this.grpShipment.Location = new System.Drawing.Point(44, 0);
			this.grpShipment.Name = "grpShipment";
			this.grpShipment.Size = new System.Drawing.Size(656, 40);
			this.grpShipment.TabIndex = 0;
			this.grpShipment.TabStop = false;
			// 
			// txtProcessingDT
			// 
			this.txtProcessingDT.AccessibleDescription = "Date Processed";
			this.txtProcessingDT.AccessibleName = "Date Processed";
			this.txtProcessingDT.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtProcessingDT.Location = new System.Drawing.Point(528, 12);
			this.txtProcessingDT.Name = "txtProcessingDT";
			this.txtProcessingDT.ReadOnly = true;
			this.txtProcessingDT.Size = new System.Drawing.Size(120, 20);
			this.txtProcessingDT.TabIndex = 3;
			this.txtProcessingDT.Text = "";
			// 
			// lblProcessingDT
			// 
			this.lblProcessingDT.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblProcessingDT.Location = new System.Drawing.Point(440, 12);
			this.lblProcessingDT.Name = "lblProcessingDT";
			this.lblProcessingDT.Size = new System.Drawing.Size(88, 20);
			this.lblProcessingDT.TabIndex = 4;
			this.lblProcessingDT.Text = "Date Processed";
			this.lblProcessingDT.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtFacility
			// 
			this.txtFacility.AccessibleDescription = "Ship To";
			this.txtFacility.AccessibleName = "Ship To";
			this.txtFacility.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFacility.Location = new System.Drawing.Point(224, 12);
			this.txtFacility.Name = "txtFacility";
			this.txtFacility.ReadOnly = true;
			this.txtFacility.Size = new System.Drawing.Size(198, 20);
			this.txtFacility.TabIndex = 2;
			this.txtFacility.Text = "";
			// 
			// txtInvoice
			// 
			this.txtInvoice.AccessibleDescription = "Invoice";
			this.txtInvoice.AccessibleName = "Invoice";
			this.txtInvoice.AutoSize = false;
			this.txtInvoice.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtInvoice.Location = new System.Drawing.Point(48, 12);
			this.txtInvoice.Name = "txtInvoice";
			this.txtInvoice.ReadOnly = true;
			this.txtInvoice.TabIndex = 1;
			this.txtInvoice.Text = "";
			// 
			// lblFacility
			// 
			this.lblFacility.Location = new System.Drawing.Point(160, 12);
			this.lblFacility.Name = "lblFacility";
			this.lblFacility.Size = new System.Drawing.Size(56, 20);
			this.lblFacility.TabIndex = 2;
			this.lblFacility.Text = "Ship To";
			this.lblFacility.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblInvoice
			// 
			this.lblInvoice.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblInvoice.Location = new System.Drawing.Point(8, 12);
			this.lblInvoice.Name = "lblInvoice";
			this.lblInvoice.Size = new System.Drawing.Size(44, 20);
			this.lblInvoice.TabIndex = 0;
			this.lblInvoice.Text = "Invoice";
			this.lblInvoice.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// InvoiceDisplayPanel
			// 
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpShipment);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "InvoiceDisplayPanel";
			this.Size = new System.Drawing.Size(700, 40);
			this.grpImage.ResumeLayout(false);
			this.grpShipment.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets docking style property
		/// </summary>
		[
		Category("Layout"),
		Description("Docking style"),
		Bindable(false),
		Browsable(true),
		]
		public override DockStyle Dock 
		{
			get 
			{ 
				return base.Dock; 
			}
			set 
			{ 
				base.Dock = value; 
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets anchor style property
		/// </summary>
		[
		Category("Layout"),
		Description("Anchor style"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get 
			{ 
				return base.Anchor; 
			}
			set 
			{ 
				base.Anchor = value; 
			}
		}

		
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Gets or sets incoming shipment indicator
		/// </summary>
		[
		Category("Design"),
		Description("Direction of Shipment. Incoming true, Outgoing false"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool IncomingShipment
		{
			get 
            { 
                return _IncomingShipment; 
            }
			set 
			{
				_IncomingShipment = value;
				if(value == true)
				{
					this.lblFacility.Text = "Shipper";
					this.lblProcessingDT.Text = "Date Received";
				}
				else
				{
					this.lblFacility.Text = "Ship To";
					this.lblProcessingDT.Text = "Date Processed";
				}
				lblFacility.Refresh();
			}
		}

		
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Gets or sets invoice to display
		/// </summary>
		public BOL.OutgoingShipmentCollection Invoice
		{
			get 
            { 
                return this._Invoice; 
            }
			set
			{
				this._Invoice = value;
				if (_Invoice != null) 
				{
                    this.IncomingShipment = _Invoice.ShipmentDirection;
					this.SetBindings();
				}
			}
		}
        
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets shipment to display
		/// </summary>
		public BOL.IncomingShipment Shipment
		{
			get 
			{ 
				return this._Shipment; 
			}
			set
			{
				this._Shipment = value;
				if (_Shipment != null) 
				{
					this.SetShipmentBindings();
				}
			}

		}

		#endregion

		#region Methods


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Private method to display invoice properties in control
		/// </summary>
		private void SetBindings()
		{
			this.OnUserActivity();
			this.txtInvoice.Text = this._Invoice.InvoiceNumber;
			this.txtFacility.Text = this._Invoice.FacilityName;
            if ( this._Invoice.ShipmentDate == DateTime.MinValue )
            {
                this.txtProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(this._Invoice.LastUpdateDate);
                lblProcessingDT.Text = "Last Modified";
            }
            else
            {
                this.txtProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(this._Invoice.ShipmentDate);
                lblProcessingDT.Text = "Shipment Date";
            }
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Private method to display shipment properties in control
		/// </summary>
		private void SetShipmentBindings()
		{
			this.txtInvoice.Text = this._Shipment.InvoiceNumber;
			this.txtFacility.Text = this._Shipment.LocalSupplier.FacilityName;
			this.txtProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(this._Shipment.ShipmentDate); 
		}

		#endregion

	}
}




